% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program Weibullcomp_costfunc.m
function L = Weibullcomp_costfunc(guess, data)

NPF = size(data, 1)/3;
Nconditions = size(data, 2);   % # of stimulus conditions
xi = 0.50;
lamda = 0.02;
L=0;
for n=1:NPF
    tau = guess(n);
    eta = guess(NPF+1);
    data1 =  data( (n-1)*3+1 : (n*3), :);

    for i=1:Nconditions
        p = xi + (1 - xi - lamda) * (1-exp(- ...
           (data1(1,i)/tau).^eta));  % Eq. 10.15
        if (p < 1/2/(data1(2, i)+data1(3, i)))     
            % putting lower and upper boundaries on p
            p = 1/2/(data1(2, i)+data1(3, i));
        elseif (p> 1-1/2/(data1(2, i)+data1(3, i)))
            p = 1- 1/2/(data1(2, i)+data1(3, i));
        end
        L = L - (data1(2, i)*log(p) + ...
            data1(3, i)*log(1-p));
    end
end
